/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.mountainmobs;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.AltarInfo;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeSky;
import com.lycanitesmobs.mountainmobs.CommonSubProxy;
import com.lycanitesmobs.mountainmobs.dispenser.DispenserBehaviorArcaneLaserStorm;
import com.lycanitesmobs.mountainmobs.dispenser.DispenserBehaviorBoulderBlast;
import com.lycanitesmobs.mountainmobs.entity.EntityArcaneLaser;
import com.lycanitesmobs.mountainmobs.entity.EntityArcaneLaserEnd;
import com.lycanitesmobs.mountainmobs.entity.EntityArcaneLaserStorm;
import com.lycanitesmobs.mountainmobs.entity.EntityBarghest;
import com.lycanitesmobs.mountainmobs.entity.EntityBeholder;
import com.lycanitesmobs.mountainmobs.entity.EntityBoulderBlast;
import com.lycanitesmobs.mountainmobs.entity.EntityGeonach;
import com.lycanitesmobs.mountainmobs.entity.EntityJabberwock;
import com.lycanitesmobs.mountainmobs.entity.EntityTroll;
import com.lycanitesmobs.mountainmobs.entity.EntityWildkin;
import com.lycanitesmobs.mountainmobs.entity.EntityYale;
import com.lycanitesmobs.mountainmobs.info.AltarInfoCelestialGeonach;
import com.lycanitesmobs.mountainmobs.item.ItemArcaneLaserStormCharge;
import com.lycanitesmobs.mountainmobs.item.ItemBoulderBlastCharge;
import com.lycanitesmobs.mountainmobs.item.ItemMountainEgg;
import com.lycanitesmobs.mountainmobs.item.ItemScepterArcaneLaserStorm;
import com.lycanitesmobs.mountainmobs.item.ItemScepterBoulderBlast;
import com.lycanitesmobs.mountainmobs.item.ItemSoulstoneMountain;
import com.lycanitesmobs.mountainmobs.mobevent.MobEventBoulderDash;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="mountainmobs", name="Lycanites Mountain Mobs", version="1.17.1.2 - MC 1.11.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.11.2]")
public class MountainMobs {
    public static final String modid = "mountainmobs";
    public static final String name = "Lycanites Mountain Mobs";
    public static GroupInfo group;
    @Mod.Instance(value="mountainmobs")
    public static MountainMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.mountainmobs.ClientSubProxy", serverSide="com.lycanitesmobs.mountainmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        group = new GroupInfo(this, "Mountain Mobs", 5).setDimensionBlacklist("-1,1").setBiomes("MOUNTAIN").setDungeonThemes("MOUNTAIN, WASTELAND, NECRO").setEggName("mountainspawn");
        group.loadFromConfig();
        ObjectManager.setCurrentGroup(group);
        ObjectManager.addItem("mountainspawn", new ItemMountainEgg());
        ObjectManager.addItem("soulstonemountain", new ItemSoulstoneMountain(group));
        ObjectManager.addItem("boulderblastcharge", new ItemBoulderBlastCharge());
        ObjectManager.addItem("boulderblastscepter", new ItemScepterBoulderBlast(), 2, 1, 1);
        ObjectManager.addItem("arcanelaserstormcharge", new ItemArcaneLaserStormCharge());
        ObjectManager.addItem("arcanelaserstormscepter", new ItemScepterArcaneLaserStorm(), 2, 1, 1);
        ObjectManager.addItem("yalemeatraw", (Item)new ItemCustomFood("yalemeatraw", group, 2, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76419_f, 45, 2, 0.8f));
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("yalemeatraw"));
        OreDictionary.registerOre((String)"listAllmuttonraw", (Item)ObjectManager.getItem("yalemeatraw"));
        ObjectManager.addItem("yalemeatcooked", (Item)new ItemCustomFood("yalemeatcooked", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setPotionEffect(MobEffects.field_76422_e, 10, 2, 1.0f).setAlwaysEdible());
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("yalemeatcooked"));
        OreDictionary.registerOre((String)"listAllmuttoncooked", (Item)ObjectManager.getItem("yalemeatcooked"));
        ObjectManager.addItem("peakskebab", new ItemCustomFood("peakskebab", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setPotionEffect(MobEffects.field_76422_e, 60, 2, 1.0f).setAlwaysEdible().func_77625_d(16), 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("peakskebab"));
        ObjectManager.addItem("barghesttreat", new ItemTreat("barghesttreat", group));
        ObjectManager.addItem("beholdertreat", new ItemTreat("beholdertreat", group));
        ObjectManager.addItem("wildkintreat", new ItemTreat("wildkintreat", group));
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("mountainspawn"), (Object)new DispenserBehaviorMobEggCustom());
        MobInfo newMob = new MobInfo(group, "jabberwock", EntityJabberwock.class, 0x662222, 0xFFFFAA).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(0).addSubspecies(new Subspecies("dark", "uncommon")).addSubspecies(new Subspecies("russet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(8).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "troll", EntityTroll.class, 30481, 0xEEEEEE).setPeaceful(false).setSummonable(true).setSummonCost(6).setDungeonLevel(2).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("russet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "yale", EntityYale.class, 0xFFEEAA, 0xFFDD77).setPeaceful(true).setSummonCost(1).setDungeonLevel(-1).addSubspecies(new Subspecies("light", "uncommon")).addSubspecies(new Subspecies("golden", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("CREATURE").setDespawn(false).setSpawnWeight(14).setAreaLimit(5).setGroupLimits(1, 4).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "geonach", EntityGeonach.class, 0x443333, 0xBBBBCC).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("keppel", "uncommon")).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("celestial", "rare"));
        newMob.spawnInfo.setSpawnTypes("ROCK").setSpawnWeight(4).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "beholder", EntityBeholder.class, 0x442211, 0x44AA33).setPeaceful(false).setTameable(true).setSummonCost(6).setDungeonLevel(2).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("SKY").setSpawnWeight(1).setAreaLimit(1).setGroupLimits(1, 1).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "barghest", EntityBarghest.class, 13664823, 1802).setPeaceful(false).setTameable(true).setSummonCost(4).setDungeonLevel(1).addSubspecies(new Subspecies("dark", "uncommon")).addSubspecies(new Subspecies("scarlet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "wildkin", EntityWildkin.class, 4405545, 7761754).setPeaceful(false).setTameable(true).setSummonCost(6).setDungeonLevel(2).addSubspecies(new Subspecies("light", "uncommon")).addSubspecies(new Subspecies("violet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        ObjectManager.addProjectile("boulderblast", EntityBoulderBlast.class, ObjectManager.getItem("boulderblastcharge"), new DispenserBehaviorBoulderBlast());
        ObjectManager.addProjectile("arcanelaserstorm", EntityArcaneLaserStorm.class, ObjectManager.getItem("arcanelaserstormcharge"), new DispenserBehaviorArcaneLaserStorm());
        ObjectManager.addProjectile("arcanelaser", EntityArcaneLaser.class);
        ObjectManager.addProjectile("arcanelaserend", EntityArcaneLaserEnd.class);
        proxy.registerModels(group);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MobInfo.loadAllFromConfigs(group);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ObjectManager.setCurrentGroup(group);
        ConfigBase config = ConfigBase.getConfig(group, "spawning");
        if (MobInfo.getFromName("geonach") != null) {
            MobEventBoulderDash mobEvent = new MobEventBoulderDash("boulderdash", group);
            SpawnTypeBase eventSpawner = new SpawnTypeSky("boulderdash").setChance(1.0).setBlockLimit(32).setMobLimit(3);
            eventSpawner.materials = new Material[]{Material.field_151579_a};
            eventSpawner.ignoreBiome = true;
            eventSpawner.ignoreLight = true;
            eventSpawner.forceSpawning = true;
            eventSpawner.ignoreMobConditions = true;
            eventSpawner.addSpawn(MobInfo.getFromName("geonach"));
            mobEvent.addSpawner(eventSpawner);
            MobEventManager.instance.addWorldEvent(mobEvent);
        }
        Biome[] biomes = MountainMobs.group.biomes;
        if (MountainMobs.group.controlVanillaSpawns) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityPig.class, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntitySheep.class, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        }
        AltarInfoCelestialGeonach celestialGeonachAltar = new AltarInfoCelestialGeonach("CelestialGeonachAltar");
        AltarInfo.addAltar(celestialGeonachAltar);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("peakskebab"), 1, 0), new Object[]{Items.field_151055_y, Items.field_151172_bF, Items.field_151127_ba, ObjectManager.getItem("yalemeatcooked")}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("yalemeatcooked"), 1, 0), new Object[]{ObjectManager.getItem("peakskebab")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("barghesttreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("yalemeatcooked"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("beholdertreat"), 4, 0), new Object[]{"   ", "BBT", "   ", Character.valueOf('T'), ObjectManager.getItem("arcanelaserstormcharge"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("wildkintreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Items.field_151128_bU, Character.valueOf('B'), Items.field_151103_aS}));
        if (ItemInfo.enableWeaponRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("boulderblastscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("boulderblastcharge"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("arcanelaserstormscepter"), 1, 0), new Object[]{" C ", " R ", " R ", Character.valueOf('C'), ObjectManager.getItem("arcanelaserstormcharge"), Character.valueOf('R'), Items.field_151072_bj}));
        }
        GameRegistry.addSmelting((Item)ObjectManager.getItem("yalemeatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("yalemeatcooked"), 1), (float)0.5f);
    }
}

